﻿import { randomUUID } from 'crypto';

export type NotificationChannel = 'email' | 'sms' | 'inapp';

export interface NotificationPayload {
  to: string;
  subject: string;
  message: string;
}

export async function sendNotification(channel: NotificationChannel, payload: NotificationPayload): Promise<{ id: string; status: 'queued' }>{
  const id = randomUUID();
  // stub: enqueue to provider-specific queue in future
  return { id, status: 'queued' };
}
