import { Router } from 'express';
import { prisma } from '../../lib/prisma.js';
const router = Router();
router.get('/', async (_req, res) => {
    try {
        // Test database connection
        await prisma.$queryRaw `SELECT 1`;
        res.json({
            status: 'healthy',
            database: 'connected',
            timestamp: new Date().toISOString()
        });
    }
    catch (error) {
        res.status(503).json({
            status: 'unhealthy',
            database: 'disconnected',
            error: 'Database connection failed'
        });
    }
});
export default router;
